/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.compras.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ModeloValoresComprobanteCompra
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> sustentos;
    private final Map<Integer, ElementoNombreValor<String>> comprobantes = new TreeMap<Integer, ElementoNombreValor<String>>();
    private final Map<Integer, ElementoNombreValor<String>> comprobantesCompras;
    private Map<String, Map<String, Set<String>>> sustentosValidosParaCompras;
    private int anio;
    private int mes;
    private boolean esMicroEmpresa;

    public int getAnio() {
        return this.anio;
    }

    public void setAnio(int anio) {
        this.anio = anio;
    }

    public int getMes() {
        return this.mes;
    }

    public void setMes(int mes) {
        this.mes = mes;
    }

    public boolean isEsMicroEmpresa() {
        return this.esMicroEmpresa;
    }

    public void setEsMicroEmpresa(boolean esMicroEmpresa) {
        this.esMicroEmpresa = esMicroEmpresa;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarSustentos();
            this.cargarComprobantesAdicional();
            this.inicializado = true;
        }
    }

    public void filtarSustentos(String tipoIdentificacion) {
        Map comprobantesObtenidos = UtilCatalogosATS.crearInstancia().obtenerComprobantesPorTransaccionIdentificacionPeriodo("1", tipoIdentificacion, this.anio, this.mes);
        for (Map.Entry<String, Map<String, Set<String>>> susObtenido : this.sustentosValidosParaCompras.entrySet()) {
            for (Map.Entry<String, Set<String>> mapaInterno : susObtenido.getValue().entrySet()) {
                for (String comprobanteSustento : mapaInterno.getValue()) {
                    if (!comprobantesObtenidos.containsKey(comprobanteSustento)) continue;
                    this.sustentos.put(susObtenido.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf(susObtenido.getKey()) + "-" + mapaInterno.getKey(), (Object)susObtenido.getKey()));
                }
            }
        }
    }

    public ModeloValoresComprobanteCompra(int anio, int mes, boolean esMicroEmpresa) {
        this.sustentos = new TreeMap<String, ElementoNombreValor<String>>();
        this.comprobantesCompras = new TreeMap<Integer, ElementoNombreValor<String>>();
        this.sustentosValidosParaCompras = new TreeMap<String, Map<String, Set<String>>>();
        this.anio = anio;
        this.mes = mes;
        this.esMicroEmpresa = esMicroEmpresa;
    }

    public void cargarSustentos() {
        this.sustentos.clear();
        this.sustentosValidosParaCompras = UtilCatalogosATS.crearInstancia().obtenerSustentosComprobante("1", this.anio, this.mes);
    }

    public void cargarComprobantes(String codigoSustento, String nombreSustento, String tipoIdentificacion) {
        this.comprobantes.clear();
        Map comprobantesObtenidos = UtilCatalogosATS.crearInstancia().obtenerComprobantesPorTransaccionIdentificacionPeriodo("1", tipoIdentificacion, this.anio, this.mes);
        int tamanio = 3;
        for (Map.Entry comprobante : comprobantesObtenidos.entrySet()) {
            Map<String, Set<String>> descripcionSustentoSetDeComprobantes = this.sustentosValidosParaCompras.get(codigoSustento);
            if (!descripcionSustentoSetDeComprobantes.get(nombreSustento.substring(tamanio)).contains(comprobante.getKey())) continue;
            this.comprobantes.put(Util.getInteger((String)comprobante.getKey()), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)comprobante.getKey()) + "-" + (String)comprobante.getValue(), (Object)((String)comprobante.getKey())));
        }
    }

    private void cargarComprobantesAdicional() {
        this.comprobantesCompras.clear();
        Map comprobantesObtenidos = UtilCatalogosATS.crearInstancia().obtenerComprobantesPorTransaccion("1");
        for (Map.Entry comp : comprobantesObtenidos.entrySet()) {
            this.comprobantesCompras.put(Util.getInteger((String)comp.getKey()), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)comp.getKey()) + "-" + (String)comp.getValue(), (Object)((String)comp.getKey())));
        }
    }

    public List<ElementoNombreValor<String>> getTiposComprobantesAdicional() {
        return new ArrayList<ElementoNombreValor<String>>(this.comprobantesCompras.values());
    }

    public ElementoNombreValor<String> obtenerTipoComprobanteAdicional(String tipoComprobante) {
        return StringUtil.isNullOrEmpty((String)tipoComprobante) ? null : this.comprobantesCompras.get(Util.getInteger(tipoComprobante));
    }

    public List<ElementoNombreValor<String>> getTipoComprobante() {
        return new ArrayList<ElementoNombreValor<String>>(this.comprobantes.values());
    }

    public ElementoNombreValor<String> obtenerTipoComprobante(String tipoComprobante) {
        return StringUtil.isNullOrEmpty((String)tipoComprobante) ? null : this.comprobantes.get(Util.getInteger(tipoComprobante));
    }

    public List<ElementoNombreValor<String>> getTipoSustento() {
        LinkedHashMap<String, ElementoNombreValor<String>> sustentosAux = new LinkedHashMap<String, ElementoNombreValor<String>>();
        ElementoNombreValor<String> tipoSustento = null;
        for (Map.Entry<String, ElementoNombreValor<String>> element : this.sustentos.entrySet()) {
            if ("00".equals(element.getKey())) {
                tipoSustento = element.getValue();
                continue;
            }
            sustentosAux.put(element.getKey(), element.getValue());
        }
        if (tipoSustento != null) {
            sustentosAux.put(tipoSustento.getNombre(), tipoSustento);
        }
        return new ArrayList<ElementoNombreValor<String>>(sustentosAux.values());
    }

    public ElementoNombreValor<String> obtenerTipoSustento(String tipoSustento) {
        return StringUtil.isNullOrEmpty((String)tipoSustento) ? null : this.sustentos.get(tipoSustento);
    }
}

